<?php
/**
 * The template to display the page title and breadcrumbs
 *
 * @package WordPress
 * @subpackage PETSLAND
 * @since PETSLAND 1.0
 */

// Page (category, tag, archive, author) title

if ( petsland_need_page_title() ) {
	petsland_sc_layouts_showed('title', true);
	?>
	<div class="top_panel_title sc_layouts_row sc_layouts_row_type_normal">
		<div class="content_wrap">
			<div class="sc_layouts_column sc_layouts_column_align_center">
				<div class="sc_layouts_item">
					<div class="sc_layouts_title sc_align_center">
						<?php
						// Blog/Post title
						?><div class="sc_layouts_title_title"><?php
							$petsland_blog_title = petsland_get_blog_title();
							$petsland_blog_title_text = $petsland_blog_title_class = $petsland_blog_title_link = $petsland_blog_title_link_text = '';
							if (is_array($petsland_blog_title)) {
								$petsland_blog_title_text = $petsland_blog_title['text'];
								$petsland_blog_title_class = !empty($petsland_blog_title['class']) ? ' '.$petsland_blog_title['class'] : '';
								$petsland_blog_title_link = !empty($petsland_blog_title['link']) ? $petsland_blog_title['link'] : '';
								$petsland_blog_title_link_text = !empty($petsland_blog_title['link_text']) ? $petsland_blog_title['link_text'] : '';
							} else
								$petsland_blog_title_text = $petsland_blog_title;
							?>
							<h1 itemprop="headline" class="sc_layouts_title_caption<?php echo esc_attr($petsland_blog_title_class); ?>"><?php
								$petsland_top_icon = petsland_get_category_icon();
								if (!empty($petsland_top_icon)) {
									$petsland_attr = petsland_getimagesize($petsland_top_icon);
									?><img src="<?php echo esc_url($petsland_top_icon); ?>" alt="<?php esc_attr__('Image', 'petsland') ?>" <?php if (!empty($petsland_attr[3])) petsland_show_layout($petsland_attr[3]);?>><?php
								}
								echo wp_kses_post($petsland_blog_title_text);
							?></h1>
							<?php
							if (!empty($petsland_blog_title_link) && !empty($petsland_blog_title_link_text)) {
								?><a href="<?php echo esc_url($petsland_blog_title_link); ?>" class="theme_button theme_button_small sc_layouts_title_link"><?php echo esc_html($petsland_blog_title_link_text); ?></a><?php
							}
							
							// Category/Tag description
							if ( is_category() || is_tag() || is_tax() ) 
								the_archive_description( '<div class="sc_layouts_title_description">', '</div>' );
		
						?></div><?php
	
						// Breadcrumbs

                        if (petsland_exists_trx_addons()) {
                            ?>
                            <div class="sc_layouts_title_breadcrumbs"><?php
                            do_action('petsland_action_breadcrumbs');
                            ?></div><?php
                        }
                            ?>
					</div>
				</div>
			</div>
		</div>
	</div>
	<?php
}
?>