<?php
// Add plugin-specific colors and fonts to the custom CSS
if (!function_exists('petsland_mailchimp_get_css')) {
	add_filter('petsland_filter_get_css', 'petsland_mailchimp_get_css', 10, 4);
	function petsland_mailchimp_get_css($css, $colors, $fonts, $scheme='') {
		
		if (isset($css['fonts']) && $fonts) {
			$css['fonts'] .= <<<CSS

CSS;
		
			
			$rad = petsland_get_border_radius();
			$css['fonts'] .= <<<CSS

.mc4wp-form .mc4wp-form-fields input[type="email"],
.mc4wp-form .mc4wp-form-fields input[type="submit"] {
	-webkit-border-radius: {$rad};
	    -ms-border-radius: {$rad};
			border-radius: {$rad};
}

CSS;
		}

		
		if (isset($css['colors']) && $colors) {
			$css['colors'] .= <<<CSS

.scheme_dark .mc4wp-form input[type="email"] {
	background-color: {$colors['bg_color']};
	border-color: {$colors['bg_color']};
	color: {$colors['text']};
}
.scheme_dark .mc4wp-form input[type="email"]::-webkit-input-placeholder { /* Chrome/Opera/Safari */
	color: {$colors['text']};
}
.scheme_dark .mc4wp-form input[type="email"]::-moz-placeholder { /* Firefox 19+ */
	color: {$colors['text']};
}
.scheme_dark .mc4wp-form input[type="email"]:-ms-input-placeholder { /* IE 10+ */
	color: {$colors['text']};
}
.scheme_dark .mc4wp-form input[type="email"]:-moz-placeholder { /* Firefox 18- */
	color: {$colors['text']};
}
.scheme_dark .mc4wp-form input[type="submit"]:hover {
	color: {$colors['bg_color']}!important;
}
.mc4wp-form .mc4wp-alert {
	background-color: {$colors['text_link']};
	border-color: {$colors['text_hover']};
	color: {$colors['inverse_text']};
}
.footer_wrap .mc4wp-form .mc4wp-response a:hover {
	color: {$colors['alter_hover']};
}
footer .mc4wp-form .mc4wp-form-fields a{ 
	color: {$colors['text_dark']};
}
footer .mc4wp-form .mc4wp-form-fields a:hover{
	color: {$colors['text_link']};	
}

CSS;
		}

		return $css;
	}
}
?>