<?php
/**
 * The template for homepage posts with "Portfolio" style
 *
 * @package WordPress
 * @subpackage PETSLAND
 * @since PETSLAND 1.0
 */

petsland_storage_set('blog_archive', true);

// Load scripts for both 'Gallery' and 'Portfolio' layouts!
wp_enqueue_script( 'imagesloaded' );
wp_enqueue_script( 'masonry' );
wp_enqueue_script( 'classie', petsland_get_file_url('js/theme.gallery/classie.min.js'), array(), null, true );
wp_enqueue_script( 'petsland-gallery-script', petsland_get_file_url('js/theme.gallery/theme.gallery.js'), array(), null, true );

get_header(); 

if (have_posts()) {

	petsland_show_layout(get_query_var('blog_archive_start'));

	$petsland_stickies = is_home() ? get_option( 'sticky_posts' ) : false;
	$petsland_sticky_out = petsland_get_theme_option('sticky_style')=='columns' 
							&& is_array($petsland_stickies) && count($petsland_stickies) > 0 && get_query_var( 'paged' ) < 1;
	
	// Show filters
	$petsland_cat = petsland_get_theme_option('parent_cat');
	$petsland_post_type = petsland_get_theme_option('post_type');
	$petsland_taxonomy = petsland_get_post_type_taxonomy($petsland_post_type);
	$petsland_show_filters = petsland_get_theme_option('show_filters');
	$petsland_tabs = array();
	if (!petsland_is_off($petsland_show_filters)) {
		$petsland_args = array(
			'type'			=> $petsland_post_type,
			'child_of'		=> $petsland_cat,
			'orderby'		=> 'name',
			'order'			=> 'ASC',
			'hide_empty'	=> 1,
			'hierarchical'	=> 0,
			'exclude'		=> '',
			'include'		=> '',
			'number'		=> '',
			'taxonomy'		=> $petsland_taxonomy,
			'pad_counts'	=> false
		);
		$petsland_portfolio_list = get_terms($petsland_args);
		if (is_array($petsland_portfolio_list) && count($petsland_portfolio_list) > 0) {
			$petsland_tabs[$petsland_cat] = esc_html__('All', 'petsland');
			foreach ($petsland_portfolio_list as $petsland_term) {
				if (isset($petsland_term->term_id)) $petsland_tabs[$petsland_term->term_id] = $petsland_term->name;
			}
		}
	}
	if (count($petsland_tabs) > 0) {
		$petsland_portfolio_filters_ajax = true;
		$petsland_portfolio_filters_active = $petsland_cat;
		$petsland_portfolio_filters_id = 'portfolio_filters';
		if (!is_customize_preview())
			wp_enqueue_script('jquery-ui-tabs', false, array('jquery', 'jquery-ui-core'), null, true);
		?>
		<div class="portfolio_filters petsland_tabs petsland_tabs_ajax">
			<ul class="portfolio_titles petsland_tabs_titles">
				<?php
				foreach ($petsland_tabs as $petsland_id=>$petsland_title) {
					?><li><a href="<?php echo esc_url(petsland_get_hash_link(sprintf('#%s_%s_content', $petsland_portfolio_filters_id, $petsland_id))); ?>" data-tab="<?php echo esc_attr($petsland_id); ?>"><?php echo esc_html($petsland_title); ?></a></li><?php
				}
				?>
			</ul>
			<?php
			$petsland_ppp = petsland_get_theme_option('posts_per_page');
			if (petsland_is_inherit($petsland_ppp)) $petsland_ppp = '';
			foreach ($petsland_tabs as $petsland_id=>$petsland_title) {
				$petsland_portfolio_need_content = $petsland_id==$petsland_portfolio_filters_active || !$petsland_portfolio_filters_ajax;
				?>
				<div id="<?php echo esc_attr(sprintf('%s_%s_content', $petsland_portfolio_filters_id, $petsland_id)); ?>"
					class="portfolio_content petsland_tabs_content"
					data-blog-template="<?php echo esc_attr(petsland_storage_get('blog_template')); ?>"
					data-blog-style="<?php echo esc_attr(petsland_get_theme_option('blog_style')); ?>"
					data-posts-per-page="<?php echo esc_attr($petsland_ppp); ?>"
					data-post-type="<?php echo esc_attr($petsland_post_type); ?>"
					data-taxonomy="<?php echo esc_attr($petsland_taxonomy); ?>"
					data-cat="<?php echo esc_attr($petsland_id); ?>"
					data-parent-cat="<?php echo esc_attr($petsland_cat); ?>"
					data-need-content="<?php echo (false===$petsland_portfolio_need_content ? 'true' : 'false'); ?>"
				>
					<?php
					if ($petsland_portfolio_need_content) 
						petsland_show_portfolio_posts(array(
							'cat' => $petsland_id,
							'parent_cat' => $petsland_cat,
							'taxonomy' => $petsland_taxonomy,
							'post_type' => $petsland_post_type,
							'page' => 1,
							'sticky' => $petsland_sticky_out
							)
						);
					?>
				</div>
				<?php
			}
			?>
		</div>
		<?php
	} else {
		petsland_show_portfolio_posts(array(
			'cat' => $petsland_cat,
			'parent_cat' => $petsland_cat,
			'taxonomy' => $petsland_taxonomy,
			'post_type' => $petsland_post_type,
			'page' => 1,
			'sticky' => $petsland_sticky_out
			)
		);
	}

	petsland_show_layout(get_query_var('blog_archive_end'));

} else {

	if ( is_search() )
		get_template_part( 'content', 'none-search' );
	else
		get_template_part( 'content', 'none-archive' );

}

get_footer();
?>