<?php
/**
 * The template for homepage posts with "Excerpt" style
 *
 * @package WordPress
 * @subpackage PETSLAND
 * @since PETSLAND 1.0
 */

petsland_storage_set('blog_archive', true);

get_header(); 

if (have_posts()) {

	petsland_show_layout(get_query_var('blog_archive_start'));

	?><div class="posts_container"><?php
	
	$petsland_stickies = is_home() ? get_option( 'sticky_posts' ) : false;
	$petsland_sticky_out = petsland_get_theme_option('sticky_style')=='columns' 
							&& is_array($petsland_stickies) && count($petsland_stickies) > 0 && get_query_var( 'paged' ) < 1;
	if ($petsland_sticky_out) {
		?><div class="sticky_wrap columns_wrap"><?php	
	}
	while ( have_posts() ) { the_post(); 
		if ($petsland_sticky_out && !is_sticky()) {
			$petsland_sticky_out = false;
			?></div><?php
		}
		get_template_part( 'content', $petsland_sticky_out && is_sticky() ? 'sticky' : 'excerpt' );
	}
	if ($petsland_sticky_out) {
		$petsland_sticky_out = false;
		?></div><?php
	}
	
	?></div><?php

	petsland_show_pagination();

	petsland_show_layout(get_query_var('blog_archive_end'));

} else {

	if ( is_search() )
		get_template_part( 'content', 'none-search' );
	else
		get_template_part( 'content', 'none-archive' );

}

get_footer();
?>