<?php
/**
 * The Gallery template to display posts
 *
 * Used for index/archive/search.
 *
 * @package WordPress
 * @subpackage PETSLAND
 * @since PETSLAND 1.0
 */

$petsland_blog_style = explode('_', petsland_get_theme_option('blog_style'));
$petsland_columns = empty($petsland_blog_style[1]) ? 2 : max(2, $petsland_blog_style[1]);
$petsland_post_format = get_post_format();
$petsland_post_format = empty($petsland_post_format) ? 'standard' : str_replace('post-format-', '', $petsland_post_format);
$petsland_animation = petsland_get_theme_option('blog_animation');
$petsland_image = wp_get_attachment_image_src( get_post_thumbnail_id(get_the_ID()), 'full' );

?><article id="post-<?php the_ID(); ?>" 
	<?php post_class( 'post_item post_layout_portfolio post_layout_gallery post_layout_gallery_'.esc_attr($petsland_columns).' post_format_'.esc_attr($petsland_post_format) ); ?>
	<?php echo (!petsland_is_off($petsland_animation) ? ' data-animation="'.esc_attr(petsland_get_animation_classes($petsland_animation)).'"' : ''); ?>
	data-size="<?php if (!empty($petsland_image[1]) && !empty($petsland_image[2])) echo intval($petsland_image[1]) .'x' . intval($petsland_image[2]); ?>"
	data-src="<?php if (!empty($petsland_image[0])) echo esc_url($petsland_image[0]); ?>"
	>

	<?php

	// Sticky label
	if ( is_sticky() && !is_paged() ) {
		?><span class="post_label label_sticky"></span><?php
	}

	// Featured image
	$petsland_image_hover = 'icon';
	if (in_array($petsland_image_hover, array('icons', 'zoom'))) $petsland_image_hover = 'dots';
	$petsland_components = petsland_is_inherit(petsland_get_theme_option_from_meta('meta_parts')) 
								? 'categories,date,counters,share'
								: petsland_array_get_keys_by_value(petsland_get_theme_option('meta_parts'));
	$petsland_counters = petsland_is_inherit(petsland_get_theme_option_from_meta('counters')) 
								? 'comments'
								: petsland_array_get_keys_by_value(petsland_get_theme_option('counters'));
	petsland_show_post_featured(array(
		'hover' => $petsland_image_hover,
		'thumb_size' => petsland_get_thumb_size( strpos(petsland_get_theme_option('body_style'), 'full')!==false || $petsland_columns < 3 ? 'masonry-big' : 'masonry' ),
		'thumb_only' => true,
		'show_no_image' => true,
		'post_info' => '<div class="post_details">'
							. '<h2 class="post_title"><a href="'.esc_url(get_permalink()).'">'. esc_html(get_the_title()) . '</a></h2>'
							. '<div class="post_description">'
								. (!empty($petsland_components)
										? petsland_show_post_meta(apply_filters('petsland_filter_post_meta_args', array(
											'components' => $petsland_components,
											'counters' => $petsland_counters,
											'seo' => false,
											'echo' => false
											), $petsland_blog_style[0], $petsland_columns))
										: '')
								. '<div class="post_description_content">'
									. apply_filters('the_excerpt', get_the_excerpt())
								. '</div>'
								. '<a href="'.esc_url(get_permalink()).'" class="theme_button post_readmore"><span class="post_readmore_label">' . esc_html__('Learn more', 'petsland') . '</span></a>'
							. '</div>'
						. '</div>'
	));
	?>
</article>