<?php
/**
 * The Classic template to display the content
 *
 * Used for index/archive/search.
 *
 * @package WordPress
 * @subpackage PETSLAND
 * @since PETSLAND 1.0
 */

$petsland_blog_style = explode('_', petsland_get_theme_option('blog_style'));
$petsland_columns = empty($petsland_blog_style[1]) ? 2 : max(2, $petsland_blog_style[1]);
$petsland_expanded = !petsland_sidebar_present() && petsland_is_on(petsland_get_theme_option('expand_content'));
$petsland_post_format = get_post_format();
$petsland_post_format = empty($petsland_post_format) ? 'standard' : str_replace('post-format-', '', $petsland_post_format);
$petsland_animation = petsland_get_theme_option('blog_animation');
$petsland_components = petsland_is_inherit(petsland_get_theme_option_from_meta('meta_parts')) 
							? 'categories,date,counters'.($petsland_columns < 3 ? ',edit' : '')
							: petsland_array_get_keys_by_value(petsland_get_theme_option('meta_parts'));
$petsland_counters = petsland_is_inherit(petsland_get_theme_option_from_meta('counters')) 
							? 'comments'
							: petsland_array_get_keys_by_value(petsland_get_theme_option('counters'));

?><div class="<?php petsland_show_layout($petsland_blog_style[0] == 'classic' ? 'column' : 'masonry_item masonry_item'); ?>-1_<?php echo esc_attr($petsland_columns); ?>"><article id="post-<?php the_ID(); ?>"
	<?php post_class( 'post_item post_format_'.esc_attr($petsland_post_format)
					. ' post_layout_classic post_layout_classic_'.esc_attr($petsland_columns)
					. ' post_layout_'.esc_attr($petsland_blog_style[0]) 
					. ' post_layout_'.esc_attr($petsland_blog_style[0]).'_'.esc_attr($petsland_columns)
					); ?>
	<?php echo (!petsland_is_off($petsland_animation) ? ' data-animation="'.esc_attr(petsland_get_animation_classes($petsland_animation)).'"' : ''); ?>>
	<?php

	// Sticky label
	if ( is_sticky() && !is_paged() ) {
		?><span class="post_label label_sticky"></span><?php
	}

	// Featured image
	petsland_show_post_featured( array( 'thumb_size' => petsland_get_thumb_size($petsland_blog_style[0] == 'classic'
													? (strpos(petsland_get_theme_option('body_style'), 'full')!==false 
															? ( $petsland_columns > 2 ? 'big' : 'huge' )
															: (	$petsland_columns > 2
																? ($petsland_expanded ? 'med' : 'small')
																: ($petsland_expanded ? 'big' : 'med')
																)
														)
													: (strpos(petsland_get_theme_option('body_style'), 'full')!==false 
															? ( $petsland_columns > 2 ? 'masonry-big' : 'full' )
															: (	$petsland_columns <= 2 && $petsland_expanded ? 'masonry-big' : 'masonry')
														)
								) ) );

	if ( !in_array($petsland_post_format, array('link', 'aside', 'status', 'quote')) ) {
		?>
		<div class="post_header entry-header">
			<?php 
			do_action('petsland_action_before_post_title'); 

			// Post title
			the_title( sprintf( '<h4 class="post_title entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h4>' );

			do_action('petsland_action_before_post_meta'); 

			// Post meta
			if (!empty($petsland_components))
				petsland_show_post_meta(apply_filters('petsland_filter_post_meta_args', array(
					'components' => $petsland_components,
					'counters' => $petsland_counters,
					'seo' => false
					), $petsland_blog_style[0], $petsland_columns)
				);

			do_action('petsland_action_after_post_meta'); 
			?>
		</div><!-- .entry-header -->
		<?php
	}		
	?>

	<div class="post_content entry-content">
		<div class="post_content_inner">
			<?php
			$petsland_show_learn_more = false;
			if (has_excerpt()) {
				the_excerpt();
			} else if (strpos(get_the_content('!--more'), '!--more')!==false) {
				the_content( '' );
			} else if (in_array($petsland_post_format, array('link', 'aside', 'status'))) {
				the_content();
			} else if ($petsland_post_format == 'quote') {
				if (($quote = petsland_get_tag(get_the_content(), '<blockquote>', '</blockquote>'))!='')
					petsland_show_layout(wpautop($quote));
				else
					the_excerpt();
			} else if (substr(get_the_content(), 0, 1)!='[') {
				the_excerpt();
			}
			?>
		</div>
		<?php
		// Post meta
		if (in_array($petsland_post_format, array('link', 'aside', 'status', 'quote'))) {
			if (!empty($petsland_components))
				petsland_show_post_meta(apply_filters('petsland_filter_post_meta_args', array(
					'components' => $petsland_components,
					'counters' => $petsland_counters
					), $petsland_blog_style[0], $petsland_columns)
				);
		}
		// More button
		if ( $petsland_show_learn_more ) {
			?><p><a class="more-link" href="<?php echo esc_url(get_permalink()); ?>"><?php esc_html_e('Read more', 'petsland'); ?></a></p><?php
		}
		?>
	</div><!-- .entry-content -->

</article></div>