<?php
/**
 * The template to display the logo or the site name and the slogan in the Header
 *
 * @package WordPress
 * @subpackage PETSLAND
 * @since PETSLAND 1.0
 */

$petsland_args = get_query_var('petsland_logo_args');

// Site logo
$petsland_logo_type   = isset($petsland_args['type']) ? $petsland_args['type'] : '';
$petsland_logo_image  = petsland_get_logo_image($petsland_logo_type);
$petsland_logo_text   = petsland_is_on(petsland_get_theme_option('logo_text')) ? get_bloginfo( 'name' ) : '';
$petsland_logo_slogan = get_bloginfo( 'description', 'display' );
if (!empty($petsland_logo_image) || !empty($petsland_logo_text)) {
	?><a class="sc_layouts_logo" href="<?php echo is_front_page() ? '#' : esc_url(home_url('/')); ?>"><?php
		if (!empty($petsland_logo_image)) {
			if (empty($petsland_logo_type) && function_exists('the_custom_logo') && (int) $petsland_logo_image > 0) {
				the_custom_logo();
			} else {
				$petsland_attr = petsland_getimagesize($petsland_logo_image);
				echo '<img src="'.esc_url($petsland_logo_image).'" alt="'.esc_attr__('Image', 'petsland').'"'.(!empty($petsland_attr[3]) ? ' '.wp_kses_data($petsland_attr[3]) : '').'>';
			}
		} else {
			petsland_show_layout(petsland_prepare_macros($petsland_logo_text), '<span class="logo_text">', '</span>');
			petsland_show_layout(petsland_prepare_macros($petsland_logo_slogan), '<span class="logo_slogan">', '</span>');
		}
	?></a><?php
}
?>