<?php
/**
 * The template to display default site header
 *
 * @package WordPress
 * @subpackage PETSLAND
 * @since PETSLAND 1.0
 */


$petsland_header_css = $petsland_header_image = '';
$petsland_header_video = petsland_get_header_video();
if (true || empty($petsland_header_video)) {
	$petsland_header_image = get_header_image();
	if (petsland_trx_addons_featured_image_override()) $petsland_header_image = petsland_get_current_mode_image($petsland_header_image);
}

?><header class="top_panel top_panel_default<?php
					echo !empty($petsland_header_image) || !empty($petsland_header_video) ? ' with_bg_image' : ' without_bg_image';
					if ($petsland_header_video!='') echo ' with_bg_video';
					if ($petsland_header_image!='') echo ' '.esc_attr(petsland_add_inline_css_class('background-image: url('.esc_url($petsland_header_image).');'));
					if (is_single() && has_post_thumbnail()) echo ' with_featured_image';
					if (petsland_is_on(petsland_get_theme_option('header_fullheight'))) echo ' header_fullheight petsland-full-height';
					?> scheme_<?php echo esc_attr(petsland_is_inherit(petsland_get_theme_option('header_scheme')) 
													? petsland_get_theme_option('color_scheme') 
													: petsland_get_theme_option('header_scheme'));
					?>"><?php

	// Background video
	if (!empty($petsland_header_video)) {
		get_template_part( 'templates/header-video' );
	}
	
	// Main menu
	if (petsland_get_theme_option("menu_style") == 'top') {
		get_template_part( 'templates/header-navi' );
	}

	// Page title and breadcrumbs area
	get_template_part( 'templates/header-title');

	// Header widgets area
	get_template_part( 'templates/header-widgets' );

?></header>