<?php
/**
 * The Sidebar containing the main widget areas.
 *
 * @package WordPress
 * @subpackage PETSLAND
 * @since PETSLAND 1.0
 */

if (petsland_sidebar_present()) {
	ob_start();
	$petsland_sidebar_name = petsland_get_theme_option('sidebar_widgets');
	petsland_storage_set('current_sidebar', 'sidebar');
	if ( is_active_sidebar($petsland_sidebar_name) ) {
		dynamic_sidebar($petsland_sidebar_name);
	}
	$petsland_out = trim(ob_get_contents());
	ob_end_clean();
	if (!empty($petsland_out)) {
		$petsland_sidebar_position = petsland_get_theme_option('sidebar_position');
		?>
		<div class="sidebar <?php echo esc_attr($petsland_sidebar_position); ?> widget_area<?php if (!petsland_is_inherit(petsland_get_theme_option('sidebar_scheme'))) echo ' scheme_'.esc_attr(petsland_get_theme_option('sidebar_scheme')); ?>" role="complementary">
			<div class="sidebar_inner">
				<?php
				do_action( 'petsland_action_before_sidebar' );
				petsland_show_layout(preg_replace("/<\/aside>[\r\n\s]*<aside/", "</aside><aside", $petsland_out));
				do_action( 'petsland_action_after_sidebar' );
				?>
			</div><!-- /.sidebar_inner -->
		</div><!-- /.sidebar -->
		<?php
	}
}
?>