<?php
/* Revolution Slider support functions
------------------------------------------------------------------------------- */

// Theme init priorities:
// 9 - register other filters (for installer, etc.)
if (!function_exists('petsland_revslider_theme_setup9')) {
	add_action( 'after_setup_theme', 'petsland_revslider_theme_setup9', 9 );
	function petsland_revslider_theme_setup9() {
		if (petsland_exists_revslider()) {
			add_action( 'wp_enqueue_scripts', 					'petsland_revslider_frontend_scripts', 1100 );
			add_filter( 'petsland_filter_merge_styles',			'petsland_revslider_merge_styles' );
		}
		if (is_admin()) {
			add_filter( 'petsland_filter_tgmpa_required_plugins','petsland_revslider_tgmpa_required_plugins' );
		}
	}
}

// Filter to add in the required plugins list
if ( !function_exists( 'petsland_revslider_tgmpa_required_plugins' ) ) {
	//Handler of the add_filter('petsland_filter_tgmpa_required_plugins',	'petsland_revslider_tgmpa_required_plugins');
	function petsland_revslider_tgmpa_required_plugins($list=array()) {
		if (petsland_storage_isset('required_plugins', 'revslider')) {
			$path = petsland_get_file_dir('plugins/revslider/revslider.zip');
			if (!empty($path) || petsland_get_theme_setting('tgmpa_upload')) {
				$list[] = array(
					'name' 		=> petsland_storage_get_array('required_plugins', 'revslider'),
					'slug' 		=> 'revslider',
					'version'	=> '6.2.2',
					'source'	=> !empty($path) ? $path : 'upload://revslider.zip',
					'required' 	=> false
				);
			}
		}
		return $list;
	}
}

// Check if RevSlider installed and activated
if ( !function_exists( 'petsland_exists_revslider' ) ) {
	function petsland_exists_revslider() {
		return function_exists('rev_slider_shortcode');
	}
}
	
// Enqueue custom styles
if ( !function_exists( 'petsland_revslider_frontend_scripts' ) ) {
	//Handler of the add_action( 'wp_enqueue_scripts', 'petsland_revslider_frontend_scripts', 1100 );
	function petsland_revslider_frontend_scripts() {
		if (petsland_is_on(petsland_get_theme_option('debug_mode')) && petsland_get_file_dir('plugins/revslider/revslider.css')!='')
			wp_enqueue_style( 'petsland-revslider',  petsland_get_file_url('plugins/revslider/revslider.css'), array(), null );
	}
}
	
// Merge custom styles
if ( !function_exists( 'petsland_revslider_merge_styles' ) ) {
	//Handler of the add_filter('petsland_filter_merge_styles', 'petsland_revslider_merge_styles');
	function petsland_revslider_merge_styles($list) {
		$list[] = 'plugins/revslider/revslider.css';
		return $list;
	}
}
?>