<?php
/**
 * The Portfolio template to display the content
 *
 * Used for index/archive/search.
 *
 * @package WordPress
 * @subpackage PETSLAND
 * @since PETSLAND 1.0
 */

$petsland_blog_style = explode('_', petsland_get_theme_option('blog_style'));
$petsland_columns = empty($petsland_blog_style[1]) ? 2 : max(2, $petsland_blog_style[1]);
$petsland_post_format = get_post_format();
$petsland_post_format = empty($petsland_post_format) ? 'standard' : str_replace('post-format-', '', $petsland_post_format);
$petsland_animation = petsland_get_theme_option('blog_animation');

?><article id="post-<?php the_ID(); ?>" 
	<?php post_class( 'post_item post_layout_portfolio post_layout_portfolio_'.esc_attr($petsland_columns).' post_format_'.esc_attr($petsland_post_format).(is_sticky() && !is_paged() ? ' sticky' : '') ); ?>
	<?php echo (!petsland_is_off($petsland_animation) ? ' data-animation="'.esc_attr(petsland_get_animation_classes($petsland_animation)).'"' : ''); ?>>
	<?php

	// Sticky label
	if ( is_sticky() && !is_paged() ) {
		?><span class="post_label label_sticky"></span><?php
	}

	$petsland_image_hover = petsland_get_theme_option('image_hover');
	// Featured image
	petsland_show_post_featured(array(
		'thumb_size' => petsland_get_thumb_size(strpos(petsland_get_theme_option('body_style'), 'full')!==false || $petsland_columns < 3 
								? 'masonry-big' 
								: 'masonry'),
		'show_no_image' => true,
		'class' => $petsland_image_hover == 'dots' ? 'hover_with_info' : '',
		'post_info' => $petsland_image_hover == 'dots' ? '<div class="post_info">'.esc_html(get_the_title()).'</div>' : ''
	));
	?>
</article>