<?php
/**
 * The Classic template to display the content
 *
 * Used for index/archive/search.
 *
 * @package WordPress
 * @subpackage PETSLAND
 * @since PETSLAND 1.0
 */

$petsland_blog_style = explode('_', petsland_get_theme_option('blog_style'));
$petsland_columns = empty($petsland_blog_style[1]) ? 1 : max(1, $petsland_blog_style[1]);
$petsland_expanded = !petsland_sidebar_present() && petsland_is_on(petsland_get_theme_option('expand_content'));
$petsland_post_format = get_post_format();
$petsland_post_format = empty($petsland_post_format) ? 'standard' : str_replace('post-format-', '', $petsland_post_format);
$petsland_animation = petsland_get_theme_option('blog_animation');

?><article id="post-<?php the_ID(); ?>" 
	<?php post_class( 'post_item post_layout_chess post_layout_chess_'.esc_attr($petsland_columns).' post_format_'.esc_attr($petsland_post_format) ); ?>
	<?php echo (!petsland_is_off($petsland_animation) ? ' data-animation="'.esc_attr(petsland_get_animation_classes($petsland_animation)).'"' : ''); ?>>

	<?php
	// Add anchor
	if ($petsland_columns == 1 && shortcode_exists('trx_sc_anchor')) {
		echo do_shortcode('[trx_sc_anchor id="post_'.esc_attr(get_the_ID()).'" title="'.the_title_attribute( array( 'echo' => false ) ).'"]');
	}

	// Sticky label
	if ( is_sticky() && !is_paged() ) {
		?><span class="post_label label_sticky"></span><?php
	}

	// Featured image
	petsland_show_post_featured( array(
											'class' => $petsland_columns == 1 ? 'petsland-full-height' : '',
											'show_no_image' => true,
											'thumb_bg' => true,
											'thumb_size' => petsland_get_thumb_size(
																	strpos(petsland_get_theme_option('body_style'), 'full')!==false
																		? ( $petsland_columns > 1 ? 'huge' : 'original' )
																		: (	$petsland_columns > 2 ? 'big' : 'huge')
																	)
											) 
										);

	?><div class="post_inner"><div class="post_inner_content"><?php 

		?><div class="post_header entry-header"><?php 
			do_action('petsland_action_before_post_title'); 

			// Post title
			the_title( sprintf( '<h3 class="post_title entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h3>' );
			
			do_action('petsland_action_before_post_meta'); 

			// Post meta
			$petsland_components = petsland_is_inherit(petsland_get_theme_option_from_meta('meta_parts')) 
										? 'categories,date'.($petsland_columns < 3 ? ',counters' : '').($petsland_columns == 1 ? ',edit' : '')
										: petsland_array_get_keys_by_value(petsland_get_theme_option('meta_parts'));
			$petsland_counters = petsland_is_inherit(petsland_get_theme_option_from_meta('counters')) 
										? 'comments'
										: petsland_array_get_keys_by_value(petsland_get_theme_option('counters'));
			$petsland_post_meta = empty($petsland_components) 
										? '' 
										: petsland_show_post_meta(apply_filters('petsland_filter_post_meta_args', array(
												'components' => $petsland_components,
												'counters' => $petsland_counters,
												'seo' => false,
												'echo' => false
												), $petsland_blog_style[0], $petsland_columns)
											);
			petsland_show_layout($petsland_post_meta);
		?></div><!-- .entry-header -->
	
		<div class="post_content entry-content">
			<div class="post_content_inner">
				<?php
				$petsland_show_learn_more = !in_array($petsland_post_format, array('link', 'aside', 'status', 'quote'));
				if (has_excerpt()) {
					the_excerpt();
				} else if (strpos(get_the_content('!--more'), '!--more')!==false) {
					the_content( '' );
				} else if (in_array($petsland_post_format, array('link', 'aside', 'status'))) {
					the_content();
				} else if ($petsland_post_format == 'quote') {
					if (($quote = petsland_get_tag(get_the_content(), '<blockquote>', '</blockquote>'))!='')
						petsland_show_layout(wpautop($quote));
					else
						the_excerpt();
				} else if (substr(get_the_content(), 0, 1)!='[') {
					the_excerpt();
				}
				?>
			</div>
			<?php
			// Post meta
			if (in_array($petsland_post_format, array('link', 'aside', 'status', 'quote'))) {
				petsland_show_layout($petsland_post_meta);
			}
			// More button
			if ( $petsland_show_learn_more ) {
				?><p><a class="more-link" href="<?php echo esc_url(get_permalink()); ?>"><?php esc_html_e('Read more', 'petsland'); ?></a></p><?php
			}
			?>
		</div><!-- .entry-content -->

	</div></div><!-- .post_inner -->

</article>